
<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('user.Dashboard')); ?></title>
    <meta name="description" content="<?php echo e(__('user.Dashboard')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('frontend-content'); ?>
    <!--=============================
        PROFILE OVERVIEW START
    ==============================-->
    <section class="wsus__profile pt_130 xs_pt_100 pb_120 xs_pb_80">

        <?php echo $__env->make('user.inc.profile_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="row">
                <div class="col-xl-8 col-lg-8">
                    <div class="wsus__profile_overview">
                        <?php if($user->about_me!=null): ?>
                            <h2><?php echo e(__('user.About Me')); ?></h2>
                            <?php echo clean(html_decode($user->about_me)); ?>

                        <?php endif; ?>
                        <?php if($user->my_skill!=null): ?>
                            <h2><?php echo e(__('user.My Skills')); ?> :</h2>
                            <?php echo clean(html_decode($user->my_skill)); ?>

                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="col-xl-4 col-lg-4">
                    <?php echo $__env->make('user.inc.user_information', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        PROFILE OVERVIEW END
    ==============================-->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('frontend_js'); ?>
<script>
    (function($) {
        "use strict";
        $(document).ready(function () {
            $("#contactWithAuthor").on("submit", function(e){
                e.preventDefault();

                var isDemo = "<?php echo e(env('APP_MODE')); ?>"
                if(isDemo == 'DEMO'){
                    toastr.error('This Is Demo Version. You Can Not Change Anything');
                    return;
                }
                 $('#submitBtn').addClass('d-none');
                 $('#showSpain').removeClass('d-none');
                $.ajax({
                    url: "<?php echo e(route('contact-with-author')); ?>",
                    type:"post",
                    data:$('#contactWithAuthor').serialize(),
                    success:function(response){
                        if(response.status == 1){
                            toastr.success(response.message)
                            $("#contactWithAuthor").trigger("reset");
                            $('#submitBtn').removeClass('d-none');
                            $('#showSpain').addClass('d-none');
                        }
                    },
                    error:function(response){
                        if(response.status == 403){
                            toastr.error(response.responseJSON.message);
                            $('#submitBtn').removeClass('d-none');
                            $('#showSpain').addClass('d-none');
                        }else{
                            if(response.responseJSON.errors.email)toastr.error(response.responseJSON.errors.email[0])
                            if(response.responseJSON.errors.message)toastr.error(response.responseJSON.errors.message[0])
                            $('#submitBtn').removeClass('d-none');
                            $('#showSpain').addClass('d-none');
                        }
                    }
                });
            });
        });
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($active_theme, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Projects\New folder\alasmart_cc\main_files\main_files\resources\views/user/dashboard.blade.php ENDPATH**/ ?>